/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.util.auimlcvt.help;

import java.util.Comparator;

public class HelpRecord
implements Comparator,
Comparable {
    private String location;
    private String fileName;
    private String status;
    private static final String STATUS_EXCLUDED = "0";
    private static final String STATUS_JAR_ONLY = "-";
    private static final String STATUS_BOTH = "+";

    public HelpRecord(String location, String fileName, String status) {
        if (location == null || fileName == null || status == null) {
            throw new IllegalArgumentException("Arguments may not be null");
        }
        if (fileName.trim().equals("")) {
            throw new IllegalArgumentException("File name may not be the empty string");
        }
        if (!(status.equals(STATUS_EXCLUDED) || status.equals(STATUS_JAR_ONLY) || status.equals(STATUS_BOTH))) {
            throw new IllegalArgumentException("Invalid status: " + status);
        }
        this.location = location.trim();
        this.fileName = fileName.trim();
        this.status = status.trim();
    }

    public boolean isExcluded() {
        return this.status.equals(STATUS_EXCLUDED);
    }

    public String getLocation() {
        return this.location;
    }

    public void setLocation(String location) {
        if (location == null) {
            throw new IllegalArgumentException("location may not be null");
        }
        this.location = location;
    }

    public String getFileName() {
        return this.fileName;
    }

    public String getStatus() {
        return this.status;
    }

    public boolean equals(Object o) {
        return o != null && o instanceof HelpRecord && ((HelpRecord)o).location.equals(this.location) && ((HelpRecord)o).fileName.equals(this.fileName) && ((HelpRecord)o).status.equals(this.status);
    }

    public int hashCode() {
        return this.location.hashCode() + this.fileName.hashCode() + this.status.hashCode();
    }

    public int compare(Object o1, Object o2) {
        HelpRecord hr1 = (HelpRecord)o1;
        HelpRecord hr2 = (HelpRecord)o2;
        int hr1length = 1;
        int hr2length = 1;
        int index = 0;
        String name = hr1.getFileName();
        while ((index = name.indexOf(46, index)) != -1) {
            ++index;
            ++hr1length;
        }
        index = 0;
        name = hr2.getFileName();
        while ((index = name.indexOf(46, index)) != -1) {
            ++index;
            ++hr2length;
        }
        if (hr1length == hr2length) {
            if (hr1.fileName.equals(hr2.fileName)) {
                if (hr1.equals(hr2)) {
                    return 0;
                }
                if (hr1.status.equals(hr2.status)) {
                    return hr2.hashCode() - hr1.hashCode();
                }
                if (hr2.status.equals(STATUS_EXCLUDED)) {
                    return -1;
                }
                if (hr1.status.equals(STATUS_EXCLUDED)) {
                    return 1;
                }
                return hr2.hashCode() - hr1.hashCode();
            }
            return hr2.fileName.compareTo(hr1.fileName);
        }
        return hr2length - hr1length;
    }

    public int compareTo(Object o) {
        return this.compare(this, o);
    }

    public String toString() {
        return "HelpRecord[location=" + this.location + ",fileName=" + this.fileName + ",status=" + this.status + "]";
    }
}

